/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.block.entity;

import dev.ftb.extendedexchange.block.entity.TickingEXBlockEntity;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class AbstractEMCBlockEntity
extends BlockEntity
implements IEmcStorage,
TickingEXBlockEntity {
    protected long storedEMC = 0L;
    private final LazyOptional<IEmcStorage> emcStorageCapability = LazyOptional.of(() -> this);

    public AbstractEMCBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.storedEMC = tag.m_128454_("StoredEMC");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("StoredEMC", this.storedEMC);
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_151543_(this.f_58858_);
        }
    }

    public long getStoredEmc() {
        return this.storedEMC;
    }

    public long getMaximumEmc() {
        return Long.MAX_VALUE;
    }

    public long extractEmc(long emc, IEmcStorage.EmcAction action) {
        long toExtract = Math.min(this.storedEMC, emc);
        if (toExtract > 0L) {
            this.storedEMC -= toExtract;
            this.m_6596_();
        }
        return toExtract;
    }

    public long insertEmc(long emc, IEmcStorage.EmcAction action) {
        long toInsert = Math.min(this.getMaximumEmc() - this.storedEMC, emc);
        if (toInsert > 0L && action.execute()) {
            this.storedEMC += toInsert;
            this.m_6596_();
        }
        return toInsert;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PECapabilities.EMC_STORAGE_CAPABILITY) {
            return this.emcStorageCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.emcStorageCapability.invalidate();
    }

    @Nonnull
    Level nonNullLevel() {
        return Objects.requireNonNull(this.m_58904_());
    }

    public NonNullList<ItemStack> getContentsToDrop() {
        return NonNullList.m_122779_();
    }
}

